/*
パーツからアートボード作成.jsx
Copyright (c) 2015 Toshiyuki Takahashi
Released under the MIT license
http://opensource.org/licenses/mit-license.php
http://www.graphicartsunit.com/
ver. 0.1.0
*/
(function() {

	// Settings
	var settings = {
		'roundArtbordBounds' : true,
		'method' : 'max',	//'max','min','round'
		'targetLayerName' : 'ex_parts'
	};

	var doc = app.activeDocument;
	var isolatedArtboard;
	var pageitems = doc.pageItems;

	// Prototype of Artboard
	function Artboard(obj) {
		this.name = obj.name;
		return this;
	};
	Artboard.prototype.remove = function() {
		doc.artboards.getByName(this.name).remove();
	};

	// Prototype of Parts
	function Parts(obj) {
		this.item = obj;
		this.name = this.item.name;
		return this;
	};
	Parts.prototype.addArtboard = function() {
		var addedArtboard = doc.artboards.add(getItemBounds(this.item));
		addedArtboard.name = this.name;
	};

	mainProcess(pageitems);

	// Main Process
	function mainProcess(items) {
		var targetItems = getTargetItems(items);
		var targetArtboards = getTargetArtboards(doc.artboards, targetItems);

		if(targetItems.length == 0) {
			alert('対象アイテムがありません。\n「' + settings.targetLayerName + '」レイヤー上に対象アイテムがあるか確認してください');
			return;
		}

		if(!confirm('パーツ用アートボード ' + targetItems.length + ' 点を追加・更新しします。よろしいですか？')) return;

		deleteArtboards(targetArtboards);

		for (var i =0; i < targetItems.length; i++) {
			targetItems[i].addArtboard();
		}
		if(isolatedArtboard && doc.artboards.length > 1) {
			isolatedArtboard.remove();
		}
	}

	// Delete target artboards
	function deleteArtboards(abs) {
		for (var i =0; i < abs.length; i++) {
			try {
				abs[i].remove();
			} catch(e) {
				if(e.message.indexOf('1128549443') != -1) {
					isolatedArtboard = abs[0];
				}
			}
		}
	}

	// Get target items
	function getTargetItems(items) {
		var targetItems = [];
		var str;
		for (var i =0; i < items.length; i++) {
			if(items[i].typename == 'SymbolItem' && items[i].name == '') items[i].name = items[i].symbol.name;
			str = items[i].name;
			if(str != '' && items[i].parent.typename == 'Layer' && items[i].parent.name == settings.targetLayerName) {
				targetItems.push(new Parts(items[i]));
			}
		}
		return targetItems;
	}

	// Get target artboards
	function getTargetArtboards(abs, items) {
		var targetArtboards = [];
		for (var i =0; i < abs.length; i++) {
			var str = abs[i].name;
			if(!str.match(/^\/{2}/) && existsArtboard(str, items)) {
				targetArtboards.push(new Artboard(abs[i]));
			}
		}
		return targetArtboards;
	}

	// Confirm the presence of Art board
	function existsArtboard(str, items) {
		for (var key in items) {
			if(items[key].name == str) return true;
		}
		return false;
	}

	// Get target item bounds
	function getItemBounds(item) {
		var bounds = item.controlBounds;
		var type = item.typename;
		if(type == 'TextFrame') {
			bounds = item.geometricBounds;
		} else if(type == 'SymbolItem') {
			bounds = item.geometricBounds;
		} else if(type == 'GroupItem' && item.clipped) {
			for (var i = 0; i < item.pageItems.length; i++) {
				if(item.pageItems[i].clipping) {
					bounds = item.pageItems[i].controlBounds;
					break;
				}
			};
		}
		if(settings.roundArtbordBounds) {
			bounds = roundBounds(bounds, settings.method);
		}
		return bounds;
	}

	// Round number of the bounds
	function roundBounds(ary, method) {
		var rounded = ary;
		switch(method) {
			case 'max':
				for (var i = 0; i < 4; i++) {
					if(i == 0 || i == 3) {
						rounded[i] = Math.floor(rounded[i]);
					} else {
						rounded[i] = Math.ceil(rounded[i]);
					}
				}
				break;
			case 'min':
				for (var i = 0; i < 4; i++) {
					if(i == 0 || i == 3) {
						rounded[i] = Math.ceil(rounded[i]);
					} else {
						rounded[i] = Math.floor(rounded[i]);
					}
				}
				break;
			case 'round':
				for (var i = 0; i < 4; i++) {
					rounded[i] = Math.round(rounded[i]);
				}
				break;
			default :
				break;
		}
		return rounded;
	}
}());